/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.NBTTags;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.event.ForgeEvent;
import noppes.npcs.api.event.potion.AffectEntity;
import noppes.npcs.api.event.potion.EndEffect;
import noppes.npcs.api.event.potion.PerformEffect;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.BaseScriptData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.Util;

public class PotionScriptData
extends BaseScriptData {
    @Override
    public ITextComponent noticeString(String type, Object event) {
        TextComponentString message = new TextComponentString("");
        message.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        if (type != null) {
            TextComponentString hook = new TextComponentString("Hook \"");
            hook.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            TextComponentString hookType = new TextComponentString(type);
            hookType.func_150256_b().func_150238_a(TextFormatting.GRAY);
            TextComponentString hookEnd = new TextComponentString("\"; ");
            hookEnd.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            message = message.func_150257_a((ITextComponent)hook).func_150257_a((ITextComponent)hookType).func_150257_a((ITextComponent)hookEnd);
        }
        TextComponentString mes = new TextComponentString("Potion Scripts");
        mes.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        message = message.func_150257_a((ITextComponent)mes);
        IEntity<?> iEntity = null;
        if (event instanceof AffectEntity && ((AffectEntity)((Object)event)).entity != null) {
            iEntity = ((AffectEntity)((Object)event)).entity;
        } else if (event instanceof EndEffect && ((EndEffect)((Object)event)).entity != null) {
            iEntity = ((EndEffect)((Object)event)).entity;
        } else if (event instanceof PerformEffect && ((PerformEffect)((Object)event)).entity != null) {
            iEntity = ((PerformEffect)((Object)event)).entity;
        }
        if (iEntity != null) {
            TextComponentString mesEntity = iEntity.getMCEntity() instanceof EntityPlayer ? new TextComponentString("Player \"") : (iEntity.getMCEntity() instanceof EntityNPCInterface ? new TextComponentString("NPC \"") : new TextComponentString("Entity \""));
            mesEntity.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            TextComponentString name = new TextComponentString(iEntity.getName());
            name.func_150256_b().func_150238_a(TextFormatting.GRAY);
            TextComponentString mesUUID = new TextComponentString("\"; UUID: \"");
            mesUUID.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            TextComponentString uuid = new TextComponentString(iEntity.getUUID());
            uuid.func_150256_b().func_150238_a(TextFormatting.GRAY);
            TextComponentString mesIn = new TextComponentString("\" in ");
            mesIn.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            double x = (double)Math.round(iEntity.getPos().getX() * 100.0) / 100.0;
            double y = (double)Math.round(iEntity.getPos().getY() * 100.0) / 100.0;
            double z = (double)Math.round(iEntity.getPos().getZ() * 100.0) / 100.0;
            int dimID = iEntity.getWorld().getMCWorld() == null ? 0 : iEntity.getWorld().getMCWorld().field_73011_w.getDimension();
            TextComponentString posClick = new TextComponentString("dimension ID:" + dimID + "; X:" + x + "; Y:" + y + "; Z:" + z);
            posClick.func_150256_b().func_150238_a(TextFormatting.BLUE).func_150228_d(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/noppes world tp @p " + dimID + " " + x + " " + y + " " + z)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("script.hover.error.pos.tp", new Object[0])));
            message = message.func_150257_a((ITextComponent)mesEntity).func_150257_a((ITextComponent)name).func_150257_a((ITextComponent)mesUUID).func_150257_a((ITextComponent)uuid).func_150257_a((ITextComponent)mesIn).func_150257_a((ITextComponent)posClick);
        }
        TextComponentString side = new TextComponentString("; Side: " + (this.isClient() ? "Client" : "Server"));
        side.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        return message.func_150257_a((ITextComponent)side);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.scripts.clear();
        this.scripts = NBTTags.GetScript(compound.func_150295_c("Scripts", 10), this, false);
        this.scriptLanguage = Util.instance.deleteColor(compound.func_74779_i("ScriptLanguage"));
        this.enabled = compound.func_74767_n("ScriptEnabled");
        if (this.scripts.isEmpty() || ((ScriptContainer)this.scripts.get((int)0)).script.isEmpty()) {
            ScriptContainer script = new ScriptContainer(this, false);
            char chr = Character.toChars(10)[0];
            script.script = "// IPotion.getCustomName() - String (custom potion name)" + chr + "// IPotion.getNbt() - INbt (nbt data)" + chr + "function isReady(event) {" + chr + "  /* event.potion - IPotion" + chr + "     event.duration - int (ticks)" + chr + "     event.amplifier - int (potion power) */" + chr + "}" + chr + "function performEffect(event) {" + chr + "  /* event.potion - IPotion" + chr + "     event.entity - IEntity" + chr + "     event.amplifier - int (potion power) */" + chr + "}" + chr + "function affectEntity(event) {" + chr + "  /* event.potion - IPotion" + chr + "     event.entity - IEntity" + chr + "     event.source - IEntity" + chr + "     event.indirectSource - IEntity" + chr + "     event.amplifier - int (potion power)" + chr + "     event.health - double (health value) */" + chr + "}" + chr + "function endEffect(event) {" + chr + "  /* event.potion - IPotion" + chr + "     event.entity - IEntity" + chr + "     event.amplifier - int (potion power) */" + chr + "}";
            if (this.scripts.isEmpty()) {
                this.scripts.add(script);
            } else {
                this.scripts.remove(0);
                this.scripts.add(0, script);
            }
        }
        this.runScript(EnumScriptType.INIT.function, new ForgeEvent.InitEvent());
    }

    @Override
    public void runScript(String type, Event event) {
        super.runScript(type, event);
        if (!this.isEnabled()) {
            return;
        }
        try {
            if (ScriptController.Instance.lastLoaded > this.lastInited) {
                this.lastInited = ScriptController.Instance.lastLoaded;
                if (!type.equalsIgnoreCase(EnumScriptType.INIT.function)) {
                    EventHooks.onPotionInit(this);
                }
            }
            for (ScriptContainer script : this.scripts) {
                script.run(type, event);
            }
        }
        catch (Exception e) {
            LogWriter.error("Error run script:", e);
        }
    }
}

